<?php
session_start();
if (empty($_SESSION['reset_user'])) {
    header('Location: reset_request_member.php');
    exit;
}

$users = json_decode(file_get_contents('users.json'), true);
$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $newPassword = trim($_POST['password']);
    if (strlen($newPassword) < 4) {
        $error = 'Password minimal 4 karakter.';
    } else {
        foreach ($users as &$user) {
            if ($user['id'] === $_SESSION['reset_user']) {
                $user['password'] = password_hash($newPassword, PASSWORD_DEFAULT);
                break;
            }
        }
        file_put_contents('users.json', json_encode($users, JSON_PRETTY_PRINT));
        unset($_SESSION['reset_user']);
        header('Location: login.php?reset=success');
        exit;
    }
}
?>
<!DOCTYPE html>
<html><head><meta charset="utf-8"><title>Ubah Password Member</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet"></head>
<body class="d-flex justify-content-center align-items-center vh-100">
<div class="card p-4" style="width:400px">
    <h4 class="mb-3 text-center">Ubah Password</h4>
    <?php if ($error): ?><div class="alert alert-danger"><?= $error ?></div><?php endif; ?>
    <form method="POST">
        <input name="password" type="password" class="form-control mb-2" placeholder="Password Baru" required>
        <button class="btn btn-success w-100">Simpan Password</button>
        <a href="login.php" class="btn btn-secondary mt-2 w-100">Batal</a>
    </form>
</div>
</body></html>
