<?php
session_start();
$users = file_exists('users.json') ? json_decode(file_get_contents('users.json'), true) : [];
$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = trim($_POST['username']);
    $userFound = false;

    foreach ($users as $user) {
        if ($user['username'] === $username && $user['role'] === 'member') {
            $userFound = true;
            $_SESSION['reset_user'] = $user['id'];
            header('Location: reset_password_member.php');
            exit;
        } elseif ($user['username'] === $username && $user['role'] === 'admin') {
            $error = 'Reset password hanya untuk member, bukan admin.';
            break;
        }
    }

    if (!$userFound && $error === '') {
        $error = 'Email tidak ditemukan.';
    }
}
?>
<!DOCTYPE html>
<html><head><meta charset="utf-8"><title>Reset Password Member</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet"></head>
<body class="d-flex justify-content-center align-items-center vh-100">
<div class="card p-4" style="width:400px">
    <h4 class="mb-3 text-center">Reset Password Member</h4>
    <?php if ($error): ?><div class="alert alert-danger"><?= $error ?></div><?php endif; ?>
    <form method="POST">
        <input name="username" class="form-control mb-2" placeholder="Masukkan Email Anda" required>
        <button class="btn btn-primary w-100">Lanjutkan</button>
        <a href="login.php" class="btn btn-secondary mt-2 w-100">Kembali ke Login</a>
    </form>
</div>
</body></html>
