<?php
session_start();
if (empty($_SESSION['role']) || $_SESSION['role']!=='admin') header('Location: login.php');
$products = json_decode(file_get_contents('products.json'), true);
$id = intval($_GET['id'] ?? 0);
$prod = array_filter($products, fn($x) => $x['id'] === $id);
if (!$prod) die('Produk tidak ditemukan');
$prod = array_shift($prod);
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $name = trim($_POST['name']);
  $price = trim($_POST['price']);
  if ($name === '' || !is_numeric($price) || $price<0) {
    $editError = 'Nama wajib dan harga harus angka positif.';
  } else {
    foreach ($products as &$p) {
      if ($p['id'] === $id) {
        $p = [
          'id'=>$id,'name'=>$name,'price'=>$price,
          'desc'=>trim($_POST['desc']),
          'link'=>trim($_POST['link']),
          'video'=>trim($_POST['video']),
          'content'=>trim($_POST['content'])
        ];
        break;
      }
    }
    file_put_contents('products.json', json_encode($products, JSON_PRETTY_PRINT));
    header('Location: admin.php'); exit;
  }
}
?>
<!DOCTYPE html><html><head><meta charset="utf-8"><title>Edit Produk</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet"></head><body class="p-4">
  <div class="card mx-auto" style="max-width:600px">
    <div class="card-header">Edit Produk</div>
    <div class="card-body">
      <?php if (!empty($editError)): ?>
        <div class="alert alert-danger"><?= $editError ?></div>
      <?php endif; ?>
      <form method="POST">
        <input name="name" class="form-control mb-2" value="<?= htmlentities($prod['name']) ?>" required>
        <input name="price" class="form-control mb-2" value="<?= htmlentities($prod['price']) ?>" pattern="\d+" required>
        <textarea name="desc" class="form-control mb-2"><?= htmlentities($prod['desc']) ?></textarea>
        <input name="link" class="form-control mb-2" value="<?= htmlentities($prod['link']) ?>">
        <input name="video" class="form-control mb-2" value="<?= htmlentities($prod['video']) ?>">
        <textarea name="content" class="form-control mb-2"><?= htmlentities($prod['content']) ?></textarea>
        <button class="btn btn-primary">Update Produk</button>
        <a href="admin.php" class="btn btn-secondary ms-2">Cancel</a>
      </form>
    </div>
  </div>
</body></html>
