<?php
session_start();
if (empty($_SESSION['user_id']) || $_SESSION['role'] !== 'member') {
    header('Location: login.php');
    exit;
}

$orderId = intval($_GET['order_id'] ?? -1);
$orders = json_decode(file_get_contents('orders.json'), true);
$order = $orders[$orderId] ?? null;

if (!$order || $order['user_id'] !== $_SESSION['user_id']) {
    die('Pesanan tidak ditemukan atau tidak valid.');
}

$products = json_decode(file_get_contents('products.json'), true);
$product = array_filter($products, fn($p) => $p['id'] === $order['product_id']);
$product = $product ? array_shift($product) : null;

if (!$product) die('Produk tidak ditemukan.');

// Nomor WhatsApp admin (ganti dengan nomor kamu)
$adminWa = '6281234567890';

// Format pesan WhatsApp
$waMessage = "Halo Admin, saya mau konfirmasi pembayaran.\n\n"
           . "Nama: " . $_SESSION['username'] . "\n"
           . "Produk: " . $product['name'] . "\n"
           . "Harga: Rp" . number_format($product['price'], 0, ',', '.') . "\n"
           . "Mohon dicek ya, terima kasih.";

$waLink = "https://wa.me/$adminWa?text=" . urlencode($waMessage);
?>
<!DOCTYPE html>
<html lang="id">
<head><meta charset="utf-8"><title>Pembayaran</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="p-4">
<div class="container">
  <h3>Pembayaran: <?= htmlentities($product['name']) ?></h3>
  <p>Harga: <strong>Rp<?= number_format($product['price'], 0, ',', '.') ?></strong></p>

  <div class="alert alert-info">
    <p><strong>Transfer ke rekening:</strong></p>
    <ul>
      <li><em>Bank:</em> BCA</li>
      <li><em>No. Rek:</em> <strong>1234‑5678‑9012</strong></li>
      <li><em>Atas Nama:</em> TRIDIGITAL LEBAK</li>
    </ul>
    <p><strong>Total Pembayaran:</strong> Rp<?= number_format($product['price'], 0, ',', '.') ?></p>
  </div>

  <a href="<?= $waLink ?>" target="_blank" class="btn btn-success">Konfirmasi Pembayaran via WhatsApp</a>
  <a href="produk.php" class="btn btn-secondary ms-2">Kembali ke Dashboard</a>
</div>
</body>
</html>
