<?php
session_start();
if (empty($_SESSION['role']) || $_SESSION['role'] !== 'admin') {
    header('Location: login.php');
    exit;
}

$dataP = file_exists('products.json') ? json_decode(file_get_contents('products.json'), true) : [];
$dataO = file_exists('orders.json') ? json_decode(file_get_contents('orders.json'), true) : [];
$users = file_exists('users.json') ? json_decode(file_get_contents('users.json'), true) : [];

$errorLanding = '';
$editMode = isset($_GET['action'], $_GET['id']) && $_GET['action'] === 'edit';
$editProd = null;
if ($editMode) {
    foreach ($dataP as $p) {
        if ($p['id'] === intval($_GET['id'])) {
            $editProd = $p;
            break;
        }
    }
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if ((isset($_POST['add_prod']) || isset($_POST['update_prod'])) && empty(trim($_POST['landingpage']))) {
        $errorLanding = 'Link landing page masih kosong. Tombol "Lihat Detail" tidak akan muncul.';
    } else {
        if (isset($_POST['add_prod'])) {
            $dataP[] = [
                'id'          => count($dataP) + 1,
                'name'        => trim($_POST['name']),
                'price'       => trim($_POST['price']),
                'desc'        => trim($_POST['desc']),
                'link'        => trim($_POST['link']),
                'video'       => trim($_POST['video']),
                'content'     => trim($_POST['content']),
                'landingpage' => trim($_POST['landingpage'])
            ];
        }
        if (isset($_POST['update_prod']) && $editProd) {
            foreach ($dataP as &$p) {
                if ($p['id'] === $editProd['id']) {
                    $p = array_merge($p, [
                        'name'        => trim($_POST['name']),
                        'price'       => trim($_POST['price']),
                        'desc'        => trim($_POST['desc']),
                        'link'        => trim($_POST['link']),
                        'video'       => trim($_POST['video']),
                        'content'     => trim($_POST['content']),
                        'landingpage' => trim($_POST['landingpage'])
                    ]);
                    break;
                }
            }
        }
        if (isset($_POST['add_prod']) || isset($_POST['update_prod'])) {
            file_put_contents('products.json', json_encode($dataP, JSON_PRETTY_PRINT));
            header('Location: admin.php');
            exit;
        }
    }

    if (isset($_POST['del_prod'])) {
        $dataP = array_values(array_filter($dataP, fn($p) => $p['id'] !== intval($_POST['del_id'])));
        file_put_contents('products.json', json_encode($dataP, JSON_PRETTY_PRINT));
        header('Location: admin.php');
        exit;
    }
    if (isset($_POST['acc'])) {
        $dataO[intval($_POST['idx'])]['status'] = 'accepted';
        file_put_contents('orders.json', json_encode($dataO, JSON_PRETTY_PRINT));
        header('Location: admin.php');
        exit;
    }
    if (isset($_POST['reject'])) {
        $dataO[intval($_POST['idx'])]['status'] = 'rejected';
        file_put_contents('orders.json', json_encode($dataO, JSON_PRETTY_PRINT));
        header('Location: admin.php');
        exit;
    }
    if (isset($_POST['add_user'])) {
        $users[] = [
            'id'          => count($users) + 1,
            'username'    => trim($_POST['username']),
            'password'    => password_hash(trim($_POST['password']), PASSWORD_DEFAULT),
            'role'        => $_POST['role'],
            'expire_date' => $_POST['expire_date']
        ];
        file_put_contents('users.json', json_encode($users, JSON_PRETTY_PRINT));
        header('Location: admin.php');
        exit;
    }
    if (isset($_POST['del_user'])) {
        $users = array_values(array_filter($users, fn($u) => $u['id'] !== intval($_POST['del_uid'])));
        file_put_contents('users.json', json_encode($users, JSON_PRETTY_PRINT));
        header('Location: admin.php');
        exit;
    }
    if (isset($_POST['logout'])) {
        session_destroy();
        header('Location: login.php');
        exit;
    }
}

$host = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? 'https' : 'http') . '://' . $_SERVER['HTTP_HOST'];
?>
<!DOCTYPE html>
<html><head><meta charset="utf-8"><title>Admin Panel</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet"></head>
<body class="d-flex">

<aside class="bg-light p-4" style="width: 240px;">
  <h4>Admin Panel</h4>
  <ul class="nav nav-pills flex-column mb-4">
    <li class="nav-item"><a class="nav-link active" data-bs-toggle="tab" href="#products">Produk</a></li>
    <li class="nav-item"><a class="nav-link" data-bs-toggle="tab" href="#orders">Pesanan</a></li>
    <li class="nav-item"><a class="nav-link" data-bs-toggle="tab" href="#users">Users</a></li>
  </ul>
  <a href="admin_dashboard.php" class="btn btn-info w-100 mb-2">Dashboard Penghasilan</a>
  <form method="POST"><button name="logout" class="btn btn-danger w-100">Logout</button></form>
</aside>

<main class="flex-grow-1 p-4"><div class="tab-content">

  <!-- Produk -->
  <div class="tab-pane fade show active" id="products">
    <div class="card mb-4"><div class="card-header"><?= $editMode ? 'Edit Produk' : 'Tambah Produk' ?></div>
      <div class="card-body">
        <?php if ($errorLanding): ?><div class="alert alert-warning"><?= htmlentities($errorLanding) ?></div><?php endif; ?>
        <form method="POST" action="<?= $editMode ? 'admin.php?action=edit&id='.$editProd['id'] : 'admin.php' ?>">
          <input name="name" class="form-control mb-2" placeholder="Nama Produk" required value="<?= $editMode ? htmlentities($editProd['name']) : '' ?>">
          <input name="price" class="form-control mb-2" placeholder="Harga" pattern="\d+" required value="<?= $editMode ? htmlentities($editProd['price']) : '' ?>">
          <textarea name="desc" class="form-control mb-2" placeholder="Deskripsi singkat"><?= $editMode ? htmlentities($editProd['desc']) : '' ?></textarea>
          <input name="link" class="form-control mb-2" placeholder="Link Tambahan" value="<?= $editMode ? htmlentities($editProd['link']) : '' ?>">
          <input name="video" class="form-control mb-2" placeholder="Link YouTube" value="<?= $editMode ? htmlentities($editProd['video']) : '' ?>">
          <textarea name="content" class="form-control mb-2" placeholder="Konten panjang"><?= $editMode ? htmlentities($editProd['content']) : '' ?></textarea>
          <input name="landingpage" class="form-control mb-2" placeholder="Link Landing Page Produk (Opsional)" value="<?= $editMode ? htmlentities($editProd['landingpage'] ?? '') : '' ?>">
          <button name="<?= $editMode ? 'update_prod' : 'add_prod' ?>" class="btn btn-<?= $editMode ? 'warning' : 'primary' ?>">
            <?= $editMode ? 'Update Produk' : 'Tambah Produk' ?></button>
          <?php if ($editMode): ?><a href="admin.php" class="btn btn-secondary ms-2">Batal Edit</a><?php endif; ?>
        </form>
      </div></div>

    <div class="card"><div class="card-header">Daftar Produk & Link Checkout</div>
      <ul class="list-group list-group-flush">
        <?php foreach ($dataP as $p): $checkoutLink = $host . '/checkout.php?id=' . $p['id']; ?>
        <li class="list-group-item d-flex justify-content-between align-items-center">
          <div><strong><?= htmlentities($p['name']) ?></strong><br>
            <small>
              Link Checkout:
              <input type="text" id="link-<?= $p['id'] ?>" value="<?= $checkoutLink ?>" readonly class="form-control form-control-sm d-inline-block" style="width:300px;">
              <button class="btn btn-sm btn-outline-secondary ms-2" onclick="copyLink('link-<?= $p['id'] ?>')">Salin Link</button>
            </small>
          </div>
          <div>
            <a href="admin.php?action=edit&id=<?= $p['id'] ?>" class="btn btn-sm btn-warning">Edit</a>
            <form method="POST" class="d-inline" onsubmit="return confirm('Hapus produk ini?');">
              <input type="hidden" name="del_id" value="<?= $p['id'] ?>">
              <button name="del_prod" class="btn btn-sm btn-danger">Hapus</button>
            </form>
          </div>
        </li>
        <?php endforeach; ?>
      </ul>
    </div>
  </div>

  <!-- Pesanan -->
  <div class="tab-pane fade" id="orders"><div class="card"><div class="card-header">Pesanan Masuk</div>
    <table class="table mb-0"><thead><tr><th>#</th><th>Nama</th><th>WA</th><th>Produk</th><th>Status</th><th>Aksi</th></tr></thead><tbody>
      <?php foreach ($dataO as $i => $o): ?>
      <tr>
        <td><?= $i+1 ?></td>
        <td><?= htmlentities($o['name']) ?></td>
        <td><?= htmlentities($o['wa']) ?></td>
        <td><?= htmlentities($o['product_name']) ?></td>
        <td><span class="badge bg-<?= $o['status']=='pending'?'warning':($o['status']=='accepted'?'success':'danger') ?>"><?= ucfirst($o['status']) ?></span></td>
        <td>
          <?php if ($o['status']=='pending'): ?>
            <form method="POST" class="d-inline"><input name="idx" value="<?= $i ?>"><button name="acc" class="btn btn-sm btn-success">Terima</button></form>
            <form method="POST" class="d-inline" onsubmit="return confirm('Tolak pesanan?');"><input name="idx" value="<?= $i ?>"><button name="reject" class="btn btn-sm btn-danger">Tolak</button></form>
          <?php elseif ($o['status']=='accepted'): ?>
            <span class="badge bg-success">Diterima</span>
          <?php else: ?>
            <span class="badge bg-danger">Ditolak</span>
          <?php endif; ?>
        </td>
      </tr>
      <?php endforeach; ?>
    </tbody></table></div></div>

  <!-- Users -->
  <div class="tab-pane fade" id="users"><div class="card mb-4"><div class="card-header">Tambah User</div>
    <div class="card-body"><form method="POST">
      <div class="row mb-2"><div class="col"><input name="username" class="form-control" placeholder="Username/Email" required></div><div class="col"><input name="password" type="password" class="form-control" placeholder="Password" required></div></div>
      <div class="row mb-2"><div class="col"><select name="role" class="form-select"><option value="member">Member</option><option value="admin">Admin</option></select></div><div class="col"><input name="expire_date" type="date" class="form-control"></div></div>
      <button name="add_user" class="btn btn-primary">Tambahkan</button>
    </form></div></div>
    <div class="card"><div class="card-header">Daftar User</div>
      <table class="table mb-0"><thead><tr><th>#</th><th>Email</th><th>Role</th><th>Expire</th><th>Status</th><th>Aksi</th></tr></thead><tbody>
        <?php foreach($users as $u): $expired = ($u['role']==='member' && !empty($u['expire_date']) && strtotime($u['expire_date'])<time()); ?>
        <tr><td><?= $u['id'] ?></td><td><?= htmlentities($u['username']) ?></td><td><?= $u['role'] ?></td><td><?= $u['expire_date']?:'-' ?></td><td><span class="badge bg-<?= $expired?'danger':'success' ?>"><?= $expired?'Expired':'Aktif' ?></span></td>
        <td><form method="POST" class="d-inline" onsubmit="return confirm('Hapus user?');"><input name="del_uid" value="<?=$u['id']?>"><button name="del_user" class="btn btn-sm btn-danger">Hapus</button></form></td></tr>
        <?php endforeach; ?>
      </tbody></table></div></div>

</div></main>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<script>
function copyLink(id) {
    const el = document.getElementById(id);
    el.select();
    el.setSelectionRange(0,99999);
    document.execCommand("copy");
    alert("Link checkout berhasil disalin!");
}
</script>
</body></html>
