<?php
session_start();
if (empty($_SESSION['role']) || $_SESSION['role'] !== 'admin') {
    header('Location: login.php');
    exit;
}

$products = json_decode(file_get_contents('products.json'), true);
$orders = json_decode(file_get_contents('orders.json'), true);

// Hitung penghasilan
$totalIncome = 0;
$incomeByProduct = [];

foreach ($orders as $o) {
    if ($o['status'] === 'sent') {
        $pid = $o['product_id'];
        $prod = array_filter($products, fn($p) => $p['id'] === $pid);
        $prod = array_shift($prod);
        $price = intval($prod['price'] ?? 0);
        $totalIncome += $price;

        if (!isset($incomeByProduct[$pid])) {
            $incomeByProduct[$pid] = [
                'name' => $prod['name'],
                'income' => 0,
                'quantity' => 0
            ];
        }
        $incomeByProduct[$pid]['income'] += $price;
        $incomeByProduct[$pid]['quantity'] += 1;
    }
}

$labels = array_column($incomeByProduct, 'name');
$values = array_column($incomeByProduct, 'income');
?>
<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Dashboard Penghasilan</title>
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="p-4">
<div class="container">
    <h2 class="mb-4">Dashboard Penghasilan</h2>

    <div class="row mb-4">
        <div class="col-12 col-md-4">
            <div class="card p-3 shadow-sm">
                <h5>Total Penghasilan</h5>
                <h3>Rp<?= number_format($totalIncome, 0, ',', '.') ?></h3>
            </div>
        </div>
    </div>

    <div class="row mb-4">
        <div class="col-12">
            <div class="card p-3 shadow-sm">
                <h5>Grafik Penghasilan per Produk</h5>
                <canvas id="chartProductIncome"></canvas>
            </div>
        </div>
    </div>

    <div class="row mb-4">
        <div class="col-12">
            <div class="card p-3 shadow-sm">
                <h5>Detail Penghasilan per Produk</h5>
                <table class="table table-bordered">
                    <thead>
                        <tr>
                            <th>Produk</th>
                            <th>Jumlah Terjual</th>
                            <th>Total Penghasilan</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($incomeByProduct as $data): ?>
                            <tr>
                                <td><?= htmlentities($data['name']) ?></td>
                                <td><?= $data['quantity'] ?> pcs</td>
                                <td>Rp<?= number_format($data['income'], 0, ',', '.') ?></td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-12">
            <a href="admin.php" class="btn btn-secondary">Kembali ke Admin Panel</a>
        </div>
    </div>
</div>

<script>
const ctx = document.getElementById('chartProductIncome').getContext('2d');
new Chart(ctx, {
    type: 'bar',
    data: {
        labels: <?= json_encode($labels) ?>,
        datasets: [{
            label: 'Penghasilan (Rp)',
            data: <?= json_encode($values) ?>,
            backgroundColor: 'rgba(75, 192, 192, 0.7)'
        }]
    },
    options: {
        scales: {
            y: { beginAtZero: true }
        }
    }
});
</script>
</body>
</html>
