<?php
session_start();
if (empty($_SESSION['user_id']) || $_SESSION['role'] !== 'member') {
    header('Location: login.php');
    exit;
}

$userId = $_SESSION['user_id'];
$username = $_SESSION['username'] ?? 'Member';

$products = file_exists('products.json') ? json_decode(file_get_contents('products.json'), true) : [];
$orders = file_exists('orders.json') ? json_decode(file_get_contents('orders.json'), true) : [];

$myOrders = array_filter($orders, fn($o) => $o['user_id'] === $userId && $o['status'] === 'accepted');
$myProductIds = array_column($myOrders, 'product_id');
$boughtProducts = array_filter($products, fn($p) => in_array($p['id'], $myProductIds));
?>
<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="utf-8">
<title>Member Dashboard</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
<style>
body { display: flex; }
.sidebar {
  width: 200px; height: 100vh;
  background: #f8f9fa; padding: 1rem;
}
.sidebar .nav-link { color: #333; }
.sidebar .nav-link.active { font-weight: bold; }
.main { flex-grow: 1; padding: 1rem; }
.header {
  display: flex; justify-content: space-between;
  align-items: center; background: #fff;
  padding: .5rem 1rem; border-bottom: 1px solid #dee2e6;
}
</style>
</head>
<body>

<!-- Sidebar -->
<div class="sidebar">
  <h5>Hi, <?= htmlentities($username) ?></h5>
  <nav class="nav flex-column mt-3">
    <a class="nav-link active" href="produk.php">Home</a>
    <a class="nav-link" href="produk.php#my-products">Produk Saya</a>
    <a class="nav-link" href="produk_available.php">Produk Tersedia</a>
    <a class="nav-link text-danger" href="logout.php">Logout</a>
  </nav>
</div>

<!-- Main Content -->
<div class="main">
  <!-- Header Navigation -->
  <div class="header">
    <h4>Member Dashboard</h4>
    <nav>
      <a href="produk.php" class="me-3">Home</a>
      <a href="produk.php#my-products" class="me-3">Produk Saya</a>
      <a href="produk_available.php" class="me-3">Produk Tersedia</a>
      <a href="logout.php" class="text-danger">Logout</a>
    </nav>
  </div>

  <!-- Produk Saya Section -->
  <div id="my-products" class="mt-4">
    <h3>Produk Saya</h3>
    <?php if (empty($boughtProducts)): ?>
      <div class="alert alert-warning">Belum ada produk yang berhasil Anda beli atau masih menunggu konfirmasi.</div>
    <?php else: ?>
      <ul class="list-group mb-3">
        <?php foreach ($boughtProducts as $prod): ?>
          <li class="list-group-item">
            <h5><?= htmlentities($prod['name']) ?></h5>
            <p><?= nl2br(htmlentities($prod['desc'])) ?></p>
            <p><strong>Harga:</strong> Rp<?= number_format($prod['price'],0,',','.') ?></p>
            <?php if (!empty($prod['link'])): ?>
              <a href="<?= htmlentities($prod['link']) ?>" target="_blank" class="btn btn-success">Download Produk</a>
            <?php else: ?>
              <span class="text-muted">Link download belum tersedia.</span>
            <?php endif; ?>
          </li>
        <?php endforeach; ?>
      </ul>
    <?php endif; ?>

    <!-- Button Beli Produk -->
    <a href="produk_available.php" class="btn btn-primary">Beli Produk Lain Disini</a>
  </div>
</div>

</body>
</html>
