<?php
session_start();
$users = file_exists('users.json') ? json_decode(file_get_contents('users.json'), true) : [];
$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $email = trim($_POST['email']);
    $password = trim($_POST['password']);
    $name = trim($_POST['name']);
    $wa = trim($_POST['wa']);
    foreach ($users as $u) {
        if ($u['username'] === $email) {
            $error = 'Email sudah terdaftar.';
            break;
        }
    }
    if (!$error) {
        $newId = count($users) + 1;
        $users[] = [
            'id' => $newId,
            'username' => $email,
            'password' => password_hash($password, PASSWORD_DEFAULT),
            'role' => 'member'
        ];
        file_put_contents('users.json', json_encode($users, JSON_PRETTY_PRINT));
        $_SESSION['user_id'] = $newId;
        $_SESSION['username'] = $email;
        $_SESSION['role'] = 'member';
        // Lanjutkan checkout otomatis
        header('Location: checkout.php?id=' . intval($_GET['id'])
              . '&pre_name=' . urlencode($name)
              . '&pre_wa=' . urlencode($wa)
        );
        exit;
    }
}
?>
<!DOCTYPE html>
<html><head><meta charset="utf-8"><title>Daftar Member</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet"></head>
<body class="d-flex justify-content-center align-items-center vh-100">
<div class="card p-4" style="width:400px">
  <h4 class="mb-3 text-center">Daftar Anggota Baru</h4>
  <?php if ($error): ?><div class="alert alert-danger"><?= $error ?></div><?php endif; ?>
  <form method="POST">
    <input type="hidden" name="id" value="<?= intval($_GET['id'] ?? 0) ?>">
    <input type="hidden" name="name" value="<?= htmlentities($_GET['name'] ?? '') ?>">
    <input type="hidden" name="wa" value="<?= htmlentities($_GET['wa'] ?? '') ?>">
    <input name="email" class="form-control mb-2" placeholder="Email" required value="<?= htmlentities($_GET['email'] ?? '') ?>">
    <input name="password" type="password" class="form-control mb-2" placeholder="Password" required>
    <button class="btn btn-primary w-100">Daftar & Lanjut Checkout</button>
    <a href="login.php" class="btn btn-secondary mt-2 w-100">Kembali ke Login</a>
  </form>
</div>
</body></html>
